/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.Lib;
import org.orecruncher.lib.compat.ModEnvironment;
import org.orecruncher.lib.reflection.BooleanField;

public final class WorldUtils {
    private static final BooleanField<ClientWorld.ClientWorldInfo> flatWorld;
    public static final float COLD_THRESHOLD = 0.2f;
    public static final float SNOW_THRESHOLD = 0.15f;
    private static final ITemperatureHandler TEMP;
    private static final IWeatherStrength RAIN_STRENGTH;
    private static final IWeatherStrength THUNDER_STRENGTH;
    private static final IWeatherAspect RAIN_OCCURING;
    private static final IWeatherAspect THUNDER_OCCURING;

    private WorldUtils() {
    }

    @Nonnull
    public static BlockPos getTopSolidOrLiquidBlock(@Nonnull IWorldReader world, @Nonnull BlockPos pos) {
        return new BlockPos(pos.func_177958_n(), world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, pos.func_177958_n(), pos.func_177952_p()), pos.func_177952_p());
    }

    public static float getTemperatureAt(@Nonnull World world, @Nonnull BlockPos pos) {
        return TEMP.getTemp(world, pos);
    }

    public static boolean isColdTemperature(float temp) {
        return temp < 0.2f;
    }

    public static boolean isSnowTemperature(float temp) {
        return temp < 0.15f;
    }

    public static boolean isSolid(@Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull Direction dir) {
        BlockState state = world.func_180495_p(pos);
        return Block.func_208061_a((VoxelShape)state.func_215685_b(world, pos, ISelectionContext.func_216377_a()), (Direction)dir);
    }

    public static boolean isTopSolid(@Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return WorldUtils.isSolid(world, pos, Direction.UP);
    }

    public static boolean isBlockSolid(@Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_200132_m();
    }

    public static boolean isAirBlock(@Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return WorldUtils.isAirBlock(world.func_180495_p(pos));
    }

    public static boolean isAirBlock(@Nonnull BlockState state) {
        return state.func_185904_a() == Material.field_151579_a;
    }

    public static Biome.RainType getCurrentPrecipitationAt(@Nonnull IWorldReader world, @Nonnull BlockPos pos) {
        if (!(world instanceof World) || !WorldUtils.isRaining((World)world)) {
            return Biome.RainType.NONE;
        }
        Biome biome = world.func_226691_t_(pos);
        if (biome.func_201851_b() == Biome.RainType.NONE) {
            return Biome.RainType.NONE;
        }
        BlockPos p = WorldUtils.getPrecipitationHeight(world, pos);
        if (p.func_177956_o() > pos.func_177956_o()) {
            return Biome.RainType.NONE;
        }
        float temp = WorldUtils.getTemperatureAt((World)world, pos);
        return WorldUtils.isSnowTemperature(temp) ? Biome.RainType.SNOW : Biome.RainType.RAIN;
    }

    public static float getRainStrength(@Nonnull World world, float partialTicks) {
        return RAIN_STRENGTH.getStrength(world, partialTicks);
    }

    public static float getThunderStrength(@Nonnull World world, float partialTicks) {
        return THUNDER_STRENGTH.getStrength(world, partialTicks);
    }

    public static boolean isRaining(@Nonnull World world) {
        return RAIN_OCCURING.isOccuring(world);
    }

    public static boolean isThundering(@Nonnull World world) {
        return THUNDER_OCCURING.isOccuring(world);
    }

    @Nonnull
    public static BlockPos getPrecipitationHeight(@Nonnull IWorldReader world, @Nonnull BlockPos pos) {
        return world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, pos);
    }

    public static boolean hasVoidParticles(@Nonnull World world) {
        return world.func_230315_m_().func_218272_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isSuperFlat(@Nonnull World world) {
        IWorldInfo info = world.func_72912_H();
        return info instanceof ClientWorld.ClientWorldInfo && (Boolean)flatWorld.get((ClientWorld.ClientWorldInfo)info) != false;
    }

    static {
        ITemperatureHandler TEMP1;
        flatWorld = new BooleanField<ClientWorld.ClientWorldInfo>(ClientWorld.ClientWorldInfo.class, false, "flatWorld", "field_239146_c_");
        if (ModEnvironment.SereneSeasons.isLoaded()) {
            try {
                Class<?> clazz = Class.forName("sereneseasons.season.SeasonHooks");
                Method method = clazz.getMethod("getBiomeTemperature", World.class, Biome.class, BlockPos.class);
                TEMP1 = (world, pos) -> {
                    try {
                        return ((Float)method.invoke(null, world, world.func_226691_t_(pos), pos)).floatValue();
                    }
                    catch (Throwable t) {
                        return world.func_226691_t_(pos).func_225486_c(pos);
                    }
                };
                Lib.LOGGER.info("Hooked SereneSeasons getBiomeTemperature()", new Object[0]);
            }
            catch (Throwable t) {
                Lib.LOGGER.warn("Unable to hook SereneSeasons getBiomeTemperature()!", new Object[0]);
                TEMP1 = (world, pos) -> world.func_226691_t_(pos).func_225486_c(pos);
            }
        } else {
            TEMP1 = (world, pos) -> world.func_226691_t_(pos).func_225486_c(pos);
        }
        TEMP = TEMP1;
        RAIN_STRENGTH = World::func_72867_j;
        RAIN_OCCURING = World::func_72896_J;
        THUNDER_STRENGTH = World::func_72819_i;
        THUNDER_OCCURING = World::func_72911_I;
    }

    private static interface IWeatherAspect {
        public boolean isOccuring(@Nonnull World var1);
    }

    private static interface IWeatherStrength {
        public float getStrength(@Nonnull World var1, float var2);
    }

    private static interface ITemperatureHandler {
        public float getTemp(@Nonnull World var1, @Nonnull BlockPos var2);
    }
}

